///////////////////////////////////////////////////
//
//	FILE:       MG84FL54_IAP_Sample_for_C.c
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	PURPOSE:    Demo IAP Function
//
///////////////////////////////////////////////////
typedef struct IAP_Addr
{  unsigned char Low ;
   unsigned char High ;
};

#define     AP_End_Addr       0x033FF
#define     IAP_Start_Addr    0x03400
#define     IAP_End_Addr      0x037FF
#define     Xtal_Freq         12              // Unit:MHz

#include    "REG_MG84FL54.H"

void IAP_Erase_512B (void) ;
void IAP_Write_512B (void) ;
void IAP_Blank_Check (unsigned int) ;
void IAP_Read_Check_512B (void) ;
void IAP_Page_Erase (unsigned int,unsigned char) ;
unsigned char IAP_Read_Byte (unsigned int,unsigned char) ;
void IAP_Write_Byte (unsigned int, unsigned char,unsigned char) ;
void IAP_Fail (void) ;

unsigned char Trigger_Check1=0x55;

///////////////////////////////////////////////////
//
//    MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{  
   P1 = 0xff;                                   //Turn off all LED

   IAP_Erase_512B() ;

   IAP_Write_512B() ;

   IAP_Read_Check_512B() ;

   P1=0xF7 ;                                    //Turn on all LED

	while (1) {}
}

///////////////////////////////////////////////////
//
//    Function:Erase
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Erase_512B (void)
{   IAP_Page_Erase(IAP_Start_Addr,0xAA) ;
    IAP_Blank_Check(IAP_Start_Addr) ;    
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Blank_Check()
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Blank_Check(unsigned int IAP_Addr)
{  unsigned int IAP_Addr_Up_Bundary=IAP_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
   {  if ( 0xFF != IAP_Read_Byte(IAP_Addr,0xAA))
         IAP_Fail() ;
   }
}

///////////////////////////////////////////////////
//
//    Function:Read 512Byte
//
///////////////////////////////////////////////////
void IAP_Read_Check_512B (void)
{  unsigned int IAP_Addr=IAP_Start_Addr;
   unsigned int IAP_Addr_Up_Bundary=IAP_Start_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
   {  unsigned char x = ((IAP_Addr>>8)+(IAP_Addr & 0xFF)) ;
      unsigned char y = IAP_Read_Byte(IAP_Addr,0xAA) ;
      if (x != y)
         IAP_Fail() ;     
   }
}

///////////////////////////////////////////////////
//
//    Function:Write 512Byte
//
///////////////////////////////////////////////////
void IAP_Write_512B (void)
{  unsigned int IAP_Addr=IAP_Start_Addr;
   unsigned int IAP_Addr_Up_Bundary=IAP_Start_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
      IAP_Write_Byte(IAP_Addr,((IAP_Addr>>8)+(IAP_Addr & 0xFF)),0xAA) ;
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Page_Erase ( Address , 0xAA ) ;
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Page_Erase(unsigned int IAP_Addr,unsigned char Trigger_Check2)
{
   CKCON = CKCON & 0x07 ;
   CKCON = CKCON | ((Xtal_Freq-1<<3)& 0xF8) ; 
   ISPCR = ISPCR | 0x83 ;       
   IFADRH = IAP_Addr >> 8 ;                     //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF ;                   //IAP Flash Address Low Byte

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00;
   ISPCR = ISPCR & 0x7C ;
}

///////////////////////////////////////////////////
//
//	   Function:x = IAP_Read_Byte(Address , 0xAA) ;
//    Read one byte from IAP address
//
///////////////////////////////////////////////////
unsigned char IAP_Read_Byte(unsigned int IAP_Addr,unsigned char Trigger_Check2)
{
   CKCON = CKCON & 0x07 ;
   CKCON = CKCON | ((Xtal_Freq-1<<3)& 0xF8) ;  
   ISPCR = ISPCR | 0x81 ;   
   IFADRH = IAP_Addr >> 8 ;                     //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF ;                   //IAP Flash Address Low Byte
   IFD = 0x00 ;

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00;
   ISPCR = ISPCR & 0x7C ;
   return(IFD);                                 //Return Flash data                                                  
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Write_Byte(Address , Data , 0xAA) ;
//    Write to IAP address one byte
//
///////////////////////////////////////////////////
void IAP_Write_Byte(unsigned int IAP_Addr, unsigned char Value,unsigned char Trigger_Check2)
{
   CKCON = CKCON & 0x07 ;
   CKCON = CKCON | ((Xtal_Freq-1<<3)& 0xF8) ; 
   ISPCR = ISPCR | 0x82 ;   
   IFADRH = IAP_Addr >> 8;                      //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF;                    //IAP Flash Address Low Byte
   IFD = Value ;                                //Flash data buffer

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00; 
   ISPCR = ISPCR & 0x7C ;
}

///////////////////////////////////////////////////
//
//    IAP_Fail()
//
///////////////////////////////////////////////////
void IAP_Fail(void)
{  P1=0xFB ;
   while(1) ;
}
